data<-read.table("Exp2 data.txt",header=T)
str(data)


data$cb<-as.factor(data$cb)
data$subject<-as.factor(data$subject)
data$code<-as.factor(data$code)
data$pos1<-as.factor(data$pos1)
data$trial<-as.factor(data$trial)
data$re<-as.factor(data$re)
data$rt_type<-as.factor(data$rt_type)
data$nr_type<-as.factor(data$nr_type)

ifelse(data$prime_type=="rel7"|data$prime_type=="unrel7","7","8")->data$primeL #prime length
data$primeL<-as.factor(data$primeL)
str(data)
ifelse(data$prime_type=="rel7"|data$prime_type=="rel8","related","unrelated")->data$primeR #prime relatedness
data$primeR<-as.factor(data$primeR)


with(data, aggregate(acc=="cor",by=list(subject=subject),mean))->subacc #subject accuracy
subacc$subject[subacc$x<0.7]->under70	


subset(data,!subject%in%under70)->dh
table(dh$cb)

#rt analyses

dim(subset(dh,trial_type=="same"))[1] #11264
dim(subset(dh,trial_type=="same"&acc=="cor"))[1] #10287	#977/11264 = 0.08673651
dim(subset(dh,trial_type=="same"&acc=="cor"&rt>150&rt<1500))[1]	#10151; (10287-10151)/10287;  #0.01322057


subset(dh,rt>150&rt<1500&acc=="cor")->trimmed	


with(subset(trimmed,trial_type=="same"),xtabs(rt~prime_type+target_type)/xtabs(~prime_type+target_type))	#mean RT, same trials
round(with(subset(trimmed,trial_type=="same"),xtabs(rt~prime_type+target_type)/xtabs(~prime_type+target_type)))



100-round(with(dh,xtabs(acc=="cor"~prime_type+target_type+trial_type)/xtabs(~prime_type+target_type+trial_type)),3)*100	#mean accuracy, same trials


round(with(subset(trimmed,trial_type=="different"),xtabs(rt~primeR+ref_type+target_type+primeL)/xtabs(~primeR+ref_type+target_type+primeL))) # full table mean rt, different trials 

(1-round(with(subset(dh,trial_type=="different"),xtabs(acc=="cor"~primeR+ref_type+target_type+primeL)/xtabs(~primeR+ref_type+target_type+primeL)),2))*100 #full mean accuracy table , different trials



library(lme4)
library(phia)



#Same trials
#RT

lmer(rt~target_type*primeR*primeL+(1|subject)+(1|trial),subset(trimmed,trial_type=="same"))->same #Converged. Models with random slopes failed to converge.
Anova(same)


#Accuracy
glmer(acc=="cor"~target_type*primeR*primeL+(1|subject)+(1|trial),family="binomial",subset(dh,trial_type=="same"))->sameacc	#Converged.
Anova(sameacc)


#Different trials

#RT

lmer(rt~target_type*primeR*primeL*ref_type+(1|subject)+(1|trial),subset(trimmed,trial_type=="different"))->diff	#Converged.
Anova(diff)

dim(subset(dh,trial_type=="different"))[1]	#11234
dim(subset(dh,trial_type=="different"&acc=="cor"))[1]	#8961 2273/11264 = 0.2017
dim(subset(dh,trial_type=="different"&acc=="cor"&rt>150&rt<1500))[1]	#8810; (8961-8810)/8961


summary(diff)$coef
linearHypothesis(diff,"target_typerep=ref_typerep") 

#pairwise comparisons
#reference target
#repeated  repeated	(target_typerep+ref_typerep+target_typerep:ref_typerep)
#repeated  unique		ref_typerep
#unique    repeated	target_typerep
#unique    unique		0



linearHypothesis(diff,"0=target_typerep") #uniq uniq - uniq rep
linearHypothesis(diff,"0=ref_typerep") #uniq uniq - rep uniq
linearHypothesis(diff,"0=target_typerep+ref_typerep+target_typerep:ref_typerep") #uniq uniq - rep rep
linearHypothesis(diff,"target_typerep=ref_typerep") #uniq rep - rep uniq
linearHypothesis(diff,"target_typerep=target_typerep+ref_typerep+target_typerep:ref_typerep") #uniq rep - rep rep
linearHypothesis(diff,"ref_typerep=target_typerep+ref_typerep+target_typerep:ref_typerep") #rep uniq - rep rep


#accuracy


glmer(acc=="cor"~target_type*ref_type+(1|subject)+(1|trial),family="binomial",subset(dh,trial_type=="different"))->diffacc0 #Converged. More complex models failed to converge.
Anova(diffacc0)	


linearHypothesis(diffacc0,"target_typerep=ref_typerep") 


1-round(with(subset(dh,trial_type=="different"), xtabs(acc=="cor"~ref_type+target_type)/xtabs(~ref_type+target_type)),2)





